package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class DelegatedAdminAccount(
    accountId: Optional[AccountId] = Optional.Absent,
    status: Optional[zio.aws.inspector2.model.DelegatedAdminStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DelegatedAdminAccount = {
    import DelegatedAdminAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DelegatedAdminAccount
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly =
    zio.aws.inspector2.model.DelegatedAdminAccount.wrap(buildAwsValue())
}
object DelegatedAdminAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DelegatedAdminAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DelegatedAdminAccount =
      zio.aws.inspector2.model.DelegatedAdminAccount(
        accountId.map(value => value),
        status.map(value => value)
      )
    def accountId: Optional[AccountId]
    def status: Optional[zio.aws.inspector2.model.DelegatedAdminStatus]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.DelegatedAdminStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DelegatedAdminAccount
  ) extends zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val status
        : Optional[zio.aws.inspector2.model.DelegatedAdminStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.inspector2.model.DelegatedAdminStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DelegatedAdminAccount
  ): zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly = new Wrapper(impl)
}
