package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.FilterArn
import scala.jdk.CollectionConverters.*
final case class DeleteFilterRequest(arn: FilterArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest = {
    import DeleteFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest
      .builder()
      .arn(FilterArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DeleteFilterRequest.ReadOnly =
    zio.aws.inspector2.model.DeleteFilterRequest.wrap(buildAwsValue())
}
object DeleteFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DeleteFilterRequest =
      zio.aws.inspector2.model.DeleteFilterRequest(arn)
    def arn: FilterArn
    def getArn: ZIO[Any, Nothing, FilterArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest
  ) extends zio.aws.inspector2.model.DeleteFilterRequest.ReadOnly {
    override val arn: FilterArn =
      zio.aws.inspector2.model.primitives.FilterArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest
  ): zio.aws.inspector2.model.DeleteFilterRequest.ReadOnly = new Wrapper(impl)
}
