package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.FilterArn
import scala.jdk.CollectionConverters.*
final case class DeleteFilterResponse(arn: FilterArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DeleteFilterResponse = {
    import DeleteFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DeleteFilterResponse
      .builder()
      .arn(FilterArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DeleteFilterResponse.ReadOnly =
    zio.aws.inspector2.model.DeleteFilterResponse.wrap(buildAwsValue())
}
object DeleteFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DeleteFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DeleteFilterResponse =
      zio.aws.inspector2.model.DeleteFilterResponse(arn)
    def arn: FilterArn
    def getArn: ZIO[Any, Nothing, FilterArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DeleteFilterResponse
  ) extends zio.aws.inspector2.model.DeleteFilterResponse.ReadOnly {
    override val arn: FilterArn =
      zio.aws.inspector2.model.primitives.FilterArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DeleteFilterResponse
  ): zio.aws.inspector2.model.DeleteFilterResponse.ReadOnly = new Wrapper(impl)
}
