package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Ec2Configuration(
    scanMode: zio.aws.inspector2.model.Ec2ScanMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Ec2Configuration = {
    import Ec2Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Ec2Configuration
      .builder()
      .scanMode(scanMode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Ec2Configuration.ReadOnly =
    zio.aws.inspector2.model.Ec2Configuration.wrap(buildAwsValue())
}
object Ec2Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Ec2Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Ec2Configuration =
      zio.aws.inspector2.model.Ec2Configuration(scanMode)
    def scanMode: zio.aws.inspector2.model.Ec2ScanMode
    def getScanMode: ZIO[Any, Nothing, zio.aws.inspector2.model.Ec2ScanMode] =
      ZIO.succeed(scanMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2Configuration
  ) extends zio.aws.inspector2.model.Ec2Configuration.ReadOnly {
    override val scanMode: zio.aws.inspector2.model.Ec2ScanMode =
      zio.aws.inspector2.model.Ec2ScanMode.wrap(impl.scanMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2Configuration
  ): zio.aws.inspector2.model.Ec2Configuration.ReadOnly = new Wrapper(impl)
}
