package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Ec2ConfigurationState(
    scanModeState: Optional[zio.aws.inspector2.model.Ec2ScanModeState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Ec2ConfigurationState = {
    import Ec2ConfigurationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Ec2ConfigurationState
      .builder()
      .optionallyWith(scanModeState.map(value => value.buildAwsValue()))(
        _.scanModeState
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Ec2ConfigurationState.ReadOnly =
    zio.aws.inspector2.model.Ec2ConfigurationState.wrap(buildAwsValue())
}
object Ec2ConfigurationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Ec2ConfigurationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Ec2ConfigurationState =
      zio.aws.inspector2.model
        .Ec2ConfigurationState(scanModeState.map(value => value.asEditable))
    def scanModeState
        : Optional[zio.aws.inspector2.model.Ec2ScanModeState.ReadOnly]
    def getScanModeState: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.Ec2ScanModeState.ReadOnly
    ] = AwsError.unwrapOptionField("scanModeState", scanModeState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2ConfigurationState
  ) extends zio.aws.inspector2.model.Ec2ConfigurationState.ReadOnly {
    override val scanModeState
        : Optional[zio.aws.inspector2.model.Ec2ScanModeState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanModeState())
        .map(value => zio.aws.inspector2.model.Ec2ScanModeState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2ConfigurationState
  ): zio.aws.inspector2.model.Ec2ConfigurationState.ReadOnly = new Wrapper(impl)
}
