package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait Ec2Platform {
  def unwrap: software.amazon.awssdk.services.inspector2.model.Ec2Platform
}
object Ec2Platform {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Ec2Platform
  ): zio.aws.inspector2.model.Ec2Platform = value match {
    case software.amazon.awssdk.services.inspector2.model.Ec2Platform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2Platform.WINDOWS =>
      val r = WINDOWS
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2Platform.LINUX =>
      val r = LINUX
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2Platform.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2Platform.MACOS =>
      val r = MACOS
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.Ec2Platform {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2Platform =
      software.amazon.awssdk.services.inspector2.model.Ec2Platform.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS extends zio.aws.inspector2.model.Ec2Platform {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2Platform =
      software.amazon.awssdk.services.inspector2.model.Ec2Platform.WINDOWS
  }
  case object LINUX extends zio.aws.inspector2.model.Ec2Platform {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2Platform =
      software.amazon.awssdk.services.inspector2.model.Ec2Platform.LINUX
  }
  case object UNKNOWN extends zio.aws.inspector2.model.Ec2Platform {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2Platform =
      software.amazon.awssdk.services.inspector2.model.Ec2Platform.UNKNOWN
  }
  case object MACOS extends zio.aws.inspector2.model.Ec2Platform {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2Platform =
      software.amazon.awssdk.services.inspector2.model.Ec2Platform.MACOS
  }
}
