package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait Ec2ScanMode {
  def unwrap: software.amazon.awssdk.services.inspector2.model.Ec2ScanMode
}
object Ec2ScanMode {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Ec2ScanMode
  ): zio.aws.inspector2.model.Ec2ScanMode = value match {
    case software.amazon.awssdk.services.inspector2.model.Ec2ScanMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2ScanMode.EC2_SSM_AGENT_BASED =>
      val r = EC2_SSM_AGENT_BASED
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2ScanMode.EC2_HYBRID =>
      val r = EC2_HYBRID
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.Ec2ScanMode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2ScanMode =
      software.amazon.awssdk.services.inspector2.model.Ec2ScanMode.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2_SSM_AGENT_BASED extends zio.aws.inspector2.model.Ec2ScanMode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2ScanMode =
      software.amazon.awssdk.services.inspector2.model.Ec2ScanMode.EC2_SSM_AGENT_BASED
  }
  case object EC2_HYBRID extends zio.aws.inspector2.model.Ec2ScanMode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2ScanMode =
      software.amazon.awssdk.services.inspector2.model.Ec2ScanMode.EC2_HYBRID
  }
}
