package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Ec2ScanModeState(
    scanMode: Optional[zio.aws.inspector2.model.Ec2ScanMode] = Optional.Absent,
    scanModeStatus: Optional[zio.aws.inspector2.model.Ec2ScanModeStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Ec2ScanModeState = {
    import Ec2ScanModeState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Ec2ScanModeState
      .builder()
      .optionallyWith(scanMode.map(value => value.unwrap))(_.scanMode)
      .optionallyWith(scanModeStatus.map(value => value.unwrap))(
        _.scanModeStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Ec2ScanModeState.ReadOnly =
    zio.aws.inspector2.model.Ec2ScanModeState.wrap(buildAwsValue())
}
object Ec2ScanModeState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Ec2ScanModeState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Ec2ScanModeState =
      zio.aws.inspector2.model.Ec2ScanModeState(
        scanMode.map(value => value),
        scanModeStatus.map(value => value)
      )
    def scanMode: Optional[zio.aws.inspector2.model.Ec2ScanMode]
    def scanModeStatus: Optional[zio.aws.inspector2.model.Ec2ScanModeStatus]
    def getScanMode: ZIO[Any, AwsError, zio.aws.inspector2.model.Ec2ScanMode] =
      AwsError.unwrapOptionField("scanMode", scanMode)
    def getScanModeStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Ec2ScanModeStatus] =
      AwsError.unwrapOptionField("scanModeStatus", scanModeStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2ScanModeState
  ) extends zio.aws.inspector2.model.Ec2ScanModeState.ReadOnly {
    override val scanMode: Optional[zio.aws.inspector2.model.Ec2ScanMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanMode())
        .map(value => zio.aws.inspector2.model.Ec2ScanMode.wrap(value))
    override val scanModeStatus
        : Optional[zio.aws.inspector2.model.Ec2ScanModeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanModeStatus())
        .map(value => zio.aws.inspector2.model.Ec2ScanModeStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2ScanModeState
  ): zio.aws.inspector2.model.Ec2ScanModeState.ReadOnly = new Wrapper(impl)
}
