package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait Ec2ScanModeStatus {
  def unwrap: software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus
}
object Ec2ScanModeStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus
  ): zio.aws.inspector2.model.Ec2ScanModeStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.Ec2ScanModeStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus =
      software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.inspector2.model.Ec2ScanModeStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus =
      software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus.SUCCESS
  }
  case object PENDING extends zio.aws.inspector2.model.Ec2ScanModeStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus =
      software.amazon.awssdk.services.inspector2.model.Ec2ScanModeStatus.PENDING
  }
}
