package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EcrConfiguration(
    pullDateRescanDuration: Optional[
      zio.aws.inspector2.model.EcrPullDateRescanDuration
    ] = Optional.Absent,
    rescanDuration: zio.aws.inspector2.model.EcrRescanDuration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EcrConfiguration = {
    import EcrConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EcrConfiguration
      .builder()
      .optionallyWith(pullDateRescanDuration.map(value => value.unwrap))(
        _.pullDateRescanDuration
      )
      .rescanDuration(rescanDuration.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.EcrConfiguration.ReadOnly =
    zio.aws.inspector2.model.EcrConfiguration.wrap(buildAwsValue())
}
object EcrConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EcrConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.EcrConfiguration =
      zio.aws.inspector2.model.EcrConfiguration(
        pullDateRescanDuration.map(value => value),
        rescanDuration
      )
    def pullDateRescanDuration
        : Optional[zio.aws.inspector2.model.EcrPullDateRescanDuration]
    def rescanDuration: zio.aws.inspector2.model.EcrRescanDuration
    def getPullDateRescanDuration: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.EcrPullDateRescanDuration
    ] = AwsError.unwrapOptionField(
      "pullDateRescanDuration",
      pullDateRescanDuration
    )
    def getRescanDuration
        : ZIO[Any, Nothing, zio.aws.inspector2.model.EcrRescanDuration] =
      ZIO.succeed(rescanDuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EcrConfiguration
  ) extends zio.aws.inspector2.model.EcrConfiguration.ReadOnly {
    override val pullDateRescanDuration
        : Optional[zio.aws.inspector2.model.EcrPullDateRescanDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pullDateRescanDuration())
        .map(value =>
          zio.aws.inspector2.model.EcrPullDateRescanDuration.wrap(value)
        )
    override val rescanDuration: zio.aws.inspector2.model.EcrRescanDuration =
      zio.aws.inspector2.model.EcrRescanDuration.wrap(impl.rescanDuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EcrConfiguration
  ): zio.aws.inspector2.model.EcrConfiguration.ReadOnly = new Wrapper(impl)
}
