package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.DateTimeTimestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EcrContainerImageMetadata(
    imagePulledAt: Optional[DateTimeTimestamp] = Optional.Absent,
    tags: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata = {
    import EcrContainerImageMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata
      .builder()
      .optionallyWith(
        imagePulledAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.imagePulledAt)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly =
    zio.aws.inspector2.model.EcrContainerImageMetadata.wrap(buildAwsValue())
}
object EcrContainerImageMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.EcrContainerImageMetadata =
      zio.aws.inspector2.model.EcrContainerImageMetadata(
        imagePulledAt.map(value => value),
        tags.map(value => value)
      )
    def imagePulledAt: Optional[DateTimeTimestamp]
    def tags: Optional[List[String]]
    def getImagePulledAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("imagePulledAt", imagePulledAt)
    def getTags: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata
  ) extends zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly {
    override val imagePulledAt: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imagePulledAt())
        .map(value =>
          zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
        )
    override val tags: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata
  ): zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly = new Wrapper(
    impl
  )
}
