package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait EcrRescanDuration {
  def unwrap: software.amazon.awssdk.services.inspector2.model.EcrRescanDuration
}
object EcrRescanDuration {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.EcrRescanDuration
  ): zio.aws.inspector2.model.EcrRescanDuration = value match {
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.LIFETIME =>
      val r = LIFETIME
      r
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.DAYS_30 =>
      val r = DAYS_30
      r
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.DAYS_180 =>
      val r = DAYS_180
      r
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.DAYS_14 =>
      val r = DAYS_14
      r
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.DAYS_60 =>
      val r = DAYS_60
      r
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.DAYS_90 =>
      val r = DAYS_90
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.EcrRescanDuration {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDuration =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.UNKNOWN_TO_SDK_VERSION
  }
  case object LIFETIME extends zio.aws.inspector2.model.EcrRescanDuration {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDuration =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.LIFETIME
  }
  case object DAYS_30 extends zio.aws.inspector2.model.EcrRescanDuration {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDuration =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.DAYS_30
  }
  case object DAYS_180 extends zio.aws.inspector2.model.EcrRescanDuration {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDuration =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.DAYS_180
  }
  case object DAYS_14 extends zio.aws.inspector2.model.EcrRescanDuration {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDuration =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.DAYS_14
  }
  case object DAYS_60 extends zio.aws.inspector2.model.EcrRescanDuration {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDuration =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.DAYS_60
  }
  case object DAYS_90 extends zio.aws.inspector2.model.EcrRescanDuration {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDuration =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDuration.DAYS_90
  }
}
