package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.DateTimeTimestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EcrRescanDurationState(
    pullDateRescanDuration: Optional[
      zio.aws.inspector2.model.EcrPullDateRescanDuration
    ] = Optional.Absent,
    rescanDuration: Optional[zio.aws.inspector2.model.EcrRescanDuration] =
      Optional.Absent,
    status: Optional[zio.aws.inspector2.model.EcrRescanDurationStatus] =
      Optional.Absent,
    updatedAt: Optional[DateTimeTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EcrRescanDurationState = {
    import EcrRescanDurationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EcrRescanDurationState
      .builder()
      .optionallyWith(pullDateRescanDuration.map(value => value.unwrap))(
        _.pullDateRescanDuration
      )
      .optionallyWith(rescanDuration.map(value => value.unwrap))(
        _.rescanDuration
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        updatedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.EcrRescanDurationState.ReadOnly =
    zio.aws.inspector2.model.EcrRescanDurationState.wrap(buildAwsValue())
}
object EcrRescanDurationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EcrRescanDurationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.EcrRescanDurationState =
      zio.aws.inspector2.model.EcrRescanDurationState(
        pullDateRescanDuration.map(value => value),
        rescanDuration.map(value => value),
        status.map(value => value),
        updatedAt.map(value => value)
      )
    def pullDateRescanDuration
        : Optional[zio.aws.inspector2.model.EcrPullDateRescanDuration]
    def rescanDuration: Optional[zio.aws.inspector2.model.EcrRescanDuration]
    def status: Optional[zio.aws.inspector2.model.EcrRescanDurationStatus]
    def updatedAt: Optional[DateTimeTimestamp]
    def getPullDateRescanDuration: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.EcrPullDateRescanDuration
    ] = AwsError.unwrapOptionField(
      "pullDateRescanDuration",
      pullDateRescanDuration
    )
    def getRescanDuration
        : ZIO[Any, AwsError, zio.aws.inspector2.model.EcrRescanDuration] =
      AwsError.unwrapOptionField("rescanDuration", rescanDuration)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.EcrRescanDurationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EcrRescanDurationState
  ) extends zio.aws.inspector2.model.EcrRescanDurationState.ReadOnly {
    override val pullDateRescanDuration
        : Optional[zio.aws.inspector2.model.EcrPullDateRescanDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pullDateRescanDuration())
        .map(value =>
          zio.aws.inspector2.model.EcrPullDateRescanDuration.wrap(value)
        )
    override val rescanDuration
        : Optional[zio.aws.inspector2.model.EcrRescanDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rescanDuration())
        .map(value => zio.aws.inspector2.model.EcrRescanDuration.wrap(value))
    override val status
        : Optional[zio.aws.inspector2.model.EcrRescanDurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.inspector2.model.EcrRescanDurationStatus.wrap(value)
        )
    override val updatedAt: Optional[DateTimeTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value =>
        zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EcrRescanDurationState
  ): zio.aws.inspector2.model.EcrRescanDurationState.ReadOnly = new Wrapper(
    impl
  )
}
