package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait EcrRescanDurationStatus {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus
}
object EcrRescanDurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus
  ): zio.aws.inspector2.model.EcrRescanDurationStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.EcrRescanDurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.inspector2.model.EcrRescanDurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus.SUCCESS
  }
  case object PENDING extends zio.aws.inspector2.model.EcrRescanDurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus.PENDING
  }
  case object FAILED extends zio.aws.inspector2.model.EcrRescanDurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus =
      software.amazon.awssdk.services.inspector2.model.EcrRescanDurationStatus.FAILED
  }
}
