package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.EpssScore
import scala.jdk.CollectionConverters.*
final case class Epss(score: Optional[EpssScore] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.inspector2.model.Epss = {
    import Epss.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Epss
      .builder()
      .optionallyWith(
        score.map(value => EpssScore.unwrap(value): java.lang.Double)
      )(_.score)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Epss.ReadOnly =
    zio.aws.inspector2.model.Epss.wrap(buildAwsValue())
}
object Epss {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.Epss] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Epss =
      zio.aws.inspector2.model.Epss(score.map(value => value))
    def score: Optional[EpssScore]
    def getScore: ZIO[Any, AwsError, EpssScore] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Epss
  ) extends zio.aws.inspector2.model.Epss.ReadOnly {
    override val score: Optional[EpssScore] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => zio.aws.inspector2.model.primitives.EpssScore(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Epss
  ): zio.aws.inspector2.model.Epss.ReadOnly = new Wrapper(impl)
}
