package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.EpssScoreValue
import scala.jdk.CollectionConverters.*
final case class EpssDetails(
    score: Optional[EpssScoreValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EpssDetails = {
    import EpssDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EpssDetails
      .builder()
      .optionallyWith(
        score.map(value => EpssScoreValue.unwrap(value): java.lang.Double)
      )(_.score)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.EpssDetails.ReadOnly =
    zio.aws.inspector2.model.EpssDetails.wrap(buildAwsValue())
}
object EpssDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EpssDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.EpssDetails =
      zio.aws.inspector2.model.EpssDetails(score.map(value => value))
    def score: Optional[EpssScoreValue]
    def getScore: ZIO[Any, AwsError, EpssScoreValue] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EpssDetails
  ) extends zio.aws.inspector2.model.EpssDetails.ReadOnly {
    override val score: Optional[EpssScoreValue] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => zio.aws.inspector2.model.primitives.EpssScoreValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EpssDetails
  ): zio.aws.inspector2.model.EpssDetails.ReadOnly = new Wrapper(impl)
}
