package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{
  EvidenceSeverity,
  EvidenceRule,
  EvidenceDetail
}
import scala.jdk.CollectionConverters.*
final case class Evidence(
    evidenceDetail: Optional[EvidenceDetail] = Optional.Absent,
    evidenceRule: Optional[EvidenceRule] = Optional.Absent,
    severity: Optional[EvidenceSeverity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Evidence = {
    import Evidence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Evidence
      .builder()
      .optionallyWith(
        evidenceDetail.map(value =>
          EvidenceDetail.unwrap(value): java.lang.String
        )
      )(_.evidenceDetail)
      .optionallyWith(
        evidenceRule.map(value => EvidenceRule.unwrap(value): java.lang.String)
      )(_.evidenceRule)
      .optionallyWith(
        severity.map(value => EvidenceSeverity.unwrap(value): java.lang.String)
      )(_.severity)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Evidence.ReadOnly =
    zio.aws.inspector2.model.Evidence.wrap(buildAwsValue())
}
object Evidence {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Evidence
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Evidence =
      zio.aws.inspector2.model.Evidence(
        evidenceDetail.map(value => value),
        evidenceRule.map(value => value),
        severity.map(value => value)
      )
    def evidenceDetail: Optional[EvidenceDetail]
    def evidenceRule: Optional[EvidenceRule]
    def severity: Optional[EvidenceSeverity]
    def getEvidenceDetail: ZIO[Any, AwsError, EvidenceDetail] =
      AwsError.unwrapOptionField("evidenceDetail", evidenceDetail)
    def getEvidenceRule: ZIO[Any, AwsError, EvidenceRule] =
      AwsError.unwrapOptionField("evidenceRule", evidenceRule)
    def getSeverity: ZIO[Any, AwsError, EvidenceSeverity] =
      AwsError.unwrapOptionField("severity", severity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Evidence
  ) extends zio.aws.inspector2.model.Evidence.ReadOnly {
    override val evidenceDetail: Optional[EvidenceDetail] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceDetail())
        .map(value => zio.aws.inspector2.model.primitives.EvidenceDetail(value))
    override val evidenceRule: Optional[EvidenceRule] = zio.aws.core.internal
      .optionalFromNullable(impl.evidenceRule())
      .map(value => zio.aws.inspector2.model.primitives.EvidenceRule(value))
    override val severity: Optional[EvidenceSeverity] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => zio.aws.inspector2.model.primitives.EvidenceSeverity(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Evidence
  ): zio.aws.inspector2.model.Evidence.ReadOnly = new Wrapper(impl)
}
