package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ExploitAvailable {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ExploitAvailable
}
object ExploitAvailable {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ExploitAvailable
  ): zio.aws.inspector2.model.ExploitAvailable = value match {
    case software.amazon.awssdk.services.inspector2.model.ExploitAvailable.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ExploitAvailable.YES =>
      val r = YES
      r
    case software.amazon.awssdk.services.inspector2.model.ExploitAvailable.NO =>
      val r = NO
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ExploitAvailable {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ExploitAvailable =
      software.amazon.awssdk.services.inspector2.model.ExploitAvailable.UNKNOWN_TO_SDK_VERSION
  }
  case object YES extends zio.aws.inspector2.model.ExploitAvailable {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ExploitAvailable =
      software.amazon.awssdk.services.inspector2.model.ExploitAvailable.YES
  }
  case object NO extends zio.aws.inspector2.model.ExploitAvailable {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ExploitAvailable =
      software.amazon.awssdk.services.inspector2.model.ExploitAvailable.NO
  }
}
