package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ExternalReportStatus {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.ExternalReportStatus
}
object ExternalReportStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ExternalReportStatus
  ): zio.aws.inspector2.model.ExternalReportStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.ExternalReportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ExternalReportStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.inspector2.model.ExternalReportStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.inspector2.model.ExternalReportStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.inspector2.model.ExternalReportStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ExternalReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ExternalReportStatus =
      software.amazon.awssdk.services.inspector2.model.ExternalReportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED extends zio.aws.inspector2.model.ExternalReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ExternalReportStatus =
      software.amazon.awssdk.services.inspector2.model.ExternalReportStatus.SUCCEEDED
  }
  case object IN_PROGRESS
      extends zio.aws.inspector2.model.ExternalReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ExternalReportStatus =
      software.amazon.awssdk.services.inspector2.model.ExternalReportStatus.IN_PROGRESS
  }
  case object CANCELLED extends zio.aws.inspector2.model.ExternalReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ExternalReportStatus =
      software.amazon.awssdk.services.inspector2.model.ExternalReportStatus.CANCELLED
  }
  case object FAILED extends zio.aws.inspector2.model.ExternalReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ExternalReportStatus =
      software.amazon.awssdk.services.inspector2.model.ExternalReportStatus.FAILED
  }
}
