package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait FilterAction {
  def unwrap: software.amazon.awssdk.services.inspector2.model.FilterAction
}
object FilterAction {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.FilterAction
  ): zio.aws.inspector2.model.FilterAction = value match {
    case software.amazon.awssdk.services.inspector2.model.FilterAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.FilterAction.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.inspector2.model.FilterAction.SUPPRESS =>
      val r = SUPPRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.FilterAction {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FilterAction =
      software.amazon.awssdk.services.inspector2.model.FilterAction.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.inspector2.model.FilterAction {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FilterAction =
      software.amazon.awssdk.services.inspector2.model.FilterAction.NONE
  }
  case object SUPPRESS extends zio.aws.inspector2.model.FilterAction {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FilterAction =
      software.amazon.awssdk.services.inspector2.model.FilterAction.SUPPRESS
  }
}
