package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  Tool,
  Cwe,
  VulnerabilityReferenceUrl,
  RiskScore,
  FindingArn,
  Ttp
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class FindingDetail(
    cisaData: Optional[zio.aws.inspector2.model.CisaData] = Optional.Absent,
    cwes: Optional[Iterable[Cwe]] = Optional.Absent,
    epssScore: Optional[Double] = Optional.Absent,
    evidences: Optional[Iterable[zio.aws.inspector2.model.Evidence]] =
      Optional.Absent,
    exploitObserved: Optional[zio.aws.inspector2.model.ExploitObserved] =
      Optional.Absent,
    findingArn: Optional[FindingArn] = Optional.Absent,
    referenceUrls: Optional[Iterable[VulnerabilityReferenceUrl]] =
      Optional.Absent,
    riskScore: Optional[RiskScore] = Optional.Absent,
    tools: Optional[Iterable[Tool]] = Optional.Absent,
    ttps: Optional[Iterable[Ttp]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FindingDetail = {
    import FindingDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FindingDetail
      .builder()
      .optionallyWith(cisaData.map(value => value.buildAwsValue()))(_.cisaData)
      .optionallyWith(
        cwes.map(value =>
          value.map { item =>
            Cwe.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.cwes)
      .optionallyWith(epssScore.map(value => value: java.lang.Double))(
        _.epssScore
      )
      .optionallyWith(
        evidences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evidences)
      .optionallyWith(exploitObserved.map(value => value.buildAwsValue()))(
        _.exploitObserved
      )
      .optionallyWith(
        findingArn.map(value => FindingArn.unwrap(value): java.lang.String)
      )(_.findingArn)
      .optionallyWith(
        referenceUrls.map(value =>
          value.map { item =>
            VulnerabilityReferenceUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.referenceUrls)
      .optionallyWith(riskScore.map(value => RiskScore.unwrap(value): Integer))(
        _.riskScore
      )
      .optionallyWith(
        tools.map(value =>
          value.map { item =>
            Tool.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tools)
      .optionallyWith(
        ttps.map(value =>
          value.map { item =>
            Ttp.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ttps)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.FindingDetail.ReadOnly =
    zio.aws.inspector2.model.FindingDetail.wrap(buildAwsValue())
}
object FindingDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FindingDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FindingDetail =
      zio.aws.inspector2.model.FindingDetail(
        cisaData.map(value => value.asEditable),
        cwes.map(value => value),
        epssScore.map(value => value),
        evidences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        exploitObserved.map(value => value.asEditable),
        findingArn.map(value => value),
        referenceUrls.map(value => value),
        riskScore.map(value => value),
        tools.map(value => value),
        ttps.map(value => value)
      )
    def cisaData: Optional[zio.aws.inspector2.model.CisaData.ReadOnly]
    def cwes: Optional[List[Cwe]]
    def epssScore: Optional[Double]
    def evidences: Optional[List[zio.aws.inspector2.model.Evidence.ReadOnly]]
    def exploitObserved
        : Optional[zio.aws.inspector2.model.ExploitObserved.ReadOnly]
    def findingArn: Optional[FindingArn]
    def referenceUrls: Optional[List[VulnerabilityReferenceUrl]]
    def riskScore: Optional[RiskScore]
    def tools: Optional[List[Tool]]
    def ttps: Optional[List[Ttp]]
    def getCisaData
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisaData.ReadOnly] =
      AwsError.unwrapOptionField("cisaData", cisaData)
    def getCwes: ZIO[Any, AwsError, List[Cwe]] =
      AwsError.unwrapOptionField("cwes", cwes)
    def getEpssScore: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("epssScore", epssScore)
    def getEvidences
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.Evidence.ReadOnly]] =
      AwsError.unwrapOptionField("evidences", evidences)
    def getExploitObserved: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ExploitObserved.ReadOnly
    ] = AwsError.unwrapOptionField("exploitObserved", exploitObserved)
    def getFindingArn: ZIO[Any, AwsError, FindingArn] =
      AwsError.unwrapOptionField("findingArn", findingArn)
    def getReferenceUrls: ZIO[Any, AwsError, List[VulnerabilityReferenceUrl]] =
      AwsError.unwrapOptionField("referenceUrls", referenceUrls)
    def getRiskScore: ZIO[Any, AwsError, RiskScore] =
      AwsError.unwrapOptionField("riskScore", riskScore)
    def getTools: ZIO[Any, AwsError, List[Tool]] =
      AwsError.unwrapOptionField("tools", tools)
    def getTtps: ZIO[Any, AwsError, List[Ttp]] =
      AwsError.unwrapOptionField("ttps", ttps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FindingDetail
  ) extends zio.aws.inspector2.model.FindingDetail.ReadOnly {
    override val cisaData
        : Optional[zio.aws.inspector2.model.CisaData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cisaData())
        .map(value => zio.aws.inspector2.model.CisaData.wrap(value))
    override val cwes: Optional[List[Cwe]] = zio.aws.core.internal
      .optionalFromNullable(impl.cwes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.Cwe(item)
        }.toList
      )
    override val epssScore: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.epssScore())
      .map(value => value: Double)
    override val evidences
        : Optional[List[zio.aws.inspector2.model.Evidence.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidences())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.Evidence.wrap(item)
          }.toList
        )
    override val exploitObserved
        : Optional[zio.aws.inspector2.model.ExploitObserved.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exploitObserved())
        .map(value => zio.aws.inspector2.model.ExploitObserved.wrap(value))
    override val findingArn: Optional[FindingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.findingArn())
      .map(value => zio.aws.inspector2.model.primitives.FindingArn(value))
    override val referenceUrls: Optional[List[VulnerabilityReferenceUrl]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referenceUrls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.VulnerabilityReferenceUrl(item)
          }.toList
        )
    override val riskScore: Optional[RiskScore] = zio.aws.core.internal
      .optionalFromNullable(impl.riskScore())
      .map(value => zio.aws.inspector2.model.primitives.RiskScore(value))
    override val tools: Optional[List[Tool]] = zio.aws.core.internal
      .optionalFromNullable(impl.tools())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.Tool(item)
        }.toList
      )
    override val ttps: Optional[List[Ttp]] = zio.aws.core.internal
      .optionalFromNullable(impl.ttps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.Ttp(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FindingDetail
  ): zio.aws.inspector2.model.FindingDetail.ReadOnly = new Wrapper(impl)
}
