package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class FindingTypeAggregationResponse(
    accountId: Optional[AccountId] = Optional.Absent,
    exploitAvailableCount: Optional[Long] = Optional.Absent,
    fixAvailableCount: Optional[Long] = Optional.Absent,
    severityCounts: Optional[zio.aws.inspector2.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FindingTypeAggregationResponse = {
    import FindingTypeAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FindingTypeAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        exploitAvailableCount.map(value => value: java.lang.Long)
      )(_.exploitAvailableCount)
      .optionallyWith(fixAvailableCount.map(value => value: java.lang.Long))(
        _.fixAvailableCount
      )
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.FindingTypeAggregationResponse
      .wrap(buildAwsValue())
}
object FindingTypeAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FindingTypeAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FindingTypeAggregationResponse =
      zio.aws.inspector2.model.FindingTypeAggregationResponse(
        accountId.map(value => value),
        exploitAvailableCount.map(value => value),
        fixAvailableCount.map(value => value),
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Optional[AccountId]
    def exploitAvailableCount: Optional[Long]
    def fixAvailableCount: Optional[Long]
    def severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getExploitAvailableCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("exploitAvailableCount", exploitAvailableCount)
    def getFixAvailableCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fixAvailableCount", fixAvailableCount)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FindingTypeAggregationResponse
  ) extends zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val exploitAvailableCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.exploitAvailableCount())
      .map(value => value: Long)
    override val fixAvailableCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.fixAvailableCount())
      .map(value => value: Long)
    override val severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FindingTypeAggregationResponse
  ): zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
