package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.MeteringAccountId
import scala.jdk.CollectionConverters.*
final case class FreeTrialAccountInfo(
    accountId: MeteringAccountId,
    freeTrialInfo: Iterable[zio.aws.inspector2.model.FreeTrialInfo]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfo = {
    import FreeTrialAccountInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfo
      .builder()
      .accountId(MeteringAccountId.unwrap(accountId): java.lang.String)
      .freeTrialInfo(freeTrialInfo.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.FreeTrialAccountInfo.ReadOnly =
    zio.aws.inspector2.model.FreeTrialAccountInfo.wrap(buildAwsValue())
}
object FreeTrialAccountInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FreeTrialAccountInfo =
      zio.aws.inspector2.model.FreeTrialAccountInfo(
        accountId,
        freeTrialInfo.map { item =>
          item.asEditable
        }
      )
    def accountId: MeteringAccountId
    def freeTrialInfo: List[zio.aws.inspector2.model.FreeTrialInfo.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, MeteringAccountId] =
      ZIO.succeed(accountId)
    def getFreeTrialInfo: ZIO[Any, Nothing, List[
      zio.aws.inspector2.model.FreeTrialInfo.ReadOnly
    ]] = ZIO.succeed(freeTrialInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfo
  ) extends zio.aws.inspector2.model.FreeTrialAccountInfo.ReadOnly {
    override val accountId: MeteringAccountId =
      zio.aws.inspector2.model.primitives.MeteringAccountId(impl.accountId())
    override val freeTrialInfo
        : List[zio.aws.inspector2.model.FreeTrialInfo.ReadOnly] = impl
      .freeTrialInfo()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.FreeTrialInfo.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfo
  ): zio.aws.inspector2.model.FreeTrialAccountInfo.ReadOnly = new Wrapper(impl)
}
