package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{AccountId, CisScanArn}
import scala.jdk.CollectionConverters.*
final case class GetCisScanReportRequest(
    reportFormat: Optional[zio.aws.inspector2.model.CisReportFormat] =
      Optional.Absent,
    scanArn: CisScanArn,
    targetAccounts: Optional[Iterable[AccountId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetCisScanReportRequest = {
    import GetCisScanReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetCisScanReportRequest
      .builder()
      .optionallyWith(reportFormat.map(value => value.unwrap))(_.reportFormat)
      .scanArn(CisScanArn.unwrap(scanArn): java.lang.String)
      .optionallyWith(
        targetAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetAccounts)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.GetCisScanReportRequest.ReadOnly =
    zio.aws.inspector2.model.GetCisScanReportRequest.wrap(buildAwsValue())
}
object GetCisScanReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetCisScanReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetCisScanReportRequest =
      zio.aws.inspector2.model.GetCisScanReportRequest(
        reportFormat.map(value => value),
        scanArn,
        targetAccounts.map(value => value)
      )
    def reportFormat: Optional[zio.aws.inspector2.model.CisReportFormat]
    def scanArn: CisScanArn
    def targetAccounts: Optional[List[AccountId]]
    def getReportFormat
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisReportFormat] =
      AwsError.unwrapOptionField("reportFormat", reportFormat)
    def getScanArn: ZIO[Any, Nothing, CisScanArn] = ZIO.succeed(scanArn)
    def getTargetAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("targetAccounts", targetAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetCisScanReportRequest
  ) extends zio.aws.inspector2.model.GetCisScanReportRequest.ReadOnly {
    override val reportFormat
        : Optional[zio.aws.inspector2.model.CisReportFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportFormat())
        .map(value => zio.aws.inspector2.model.CisReportFormat.wrap(value))
    override val scanArn: CisScanArn =
      zio.aws.inspector2.model.primitives.CisScanArn(impl.scanArn())
    override val targetAccounts: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.AccountId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetCisScanReportRequest
  ): zio.aws.inspector2.model.GetCisScanReportRequest.ReadOnly = new Wrapper(
    impl
  )
}
