package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCisScanReportResponse(
    status: Optional[zio.aws.inspector2.model.CisReportStatus] =
      Optional.Absent,
    url: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetCisScanReportResponse = {
    import GetCisScanReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetCisScanReportResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.GetCisScanReportResponse.ReadOnly =
    zio.aws.inspector2.model.GetCisScanReportResponse.wrap(buildAwsValue())
}
object GetCisScanReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetCisScanReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetCisScanReportResponse =
      zio.aws.inspector2.model.GetCisScanReportResponse(
        status.map(value => value),
        url.map(value => value)
      )
    def status: Optional[zio.aws.inspector2.model.CisReportStatus]
    def url: Optional[String]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisReportStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetCisScanReportResponse
  ) extends zio.aws.inspector2.model.GetCisScanReportResponse.ReadOnly {
    override val status: Optional[zio.aws.inspector2.model.CisReportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.inspector2.model.CisReportStatus.wrap(value))
    override val url: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetCisScanReportResponse
  ): zio.aws.inspector2.model.GetCisScanReportResponse.ReadOnly = new Wrapper(
    impl
  )
}
