package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  NextToken,
  AccountId,
  CisScanArn,
  GetCisScanResultDetailsMaxResults,
  ResourceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetCisScanResultDetailsRequest(
    accountId: AccountId,
    filterCriteria: Optional[
      zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria
    ] = Optional.Absent,
    maxResults: Optional[GetCisScanResultDetailsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    scanArn: CisScanArn,
    sortBy: Optional[zio.aws.inspector2.model.CisScanResultDetailsSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder] =
      Optional.Absent,
    targetResourceId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest = {
    import GetCisScanResultDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maxResults.map(value =>
          GetCisScanResultDetailsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .scanArn(CisScanArn.unwrap(scanArn): java.lang.String)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .targetResourceId(ResourceId.unwrap(targetResourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.GetCisScanResultDetailsRequest.ReadOnly =
    zio.aws.inspector2.model.GetCisScanResultDetailsRequest
      .wrap(buildAwsValue())
}
object GetCisScanResultDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetCisScanResultDetailsRequest =
      zio.aws.inspector2.model.GetCisScanResultDetailsRequest(
        accountId,
        filterCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        scanArn,
        sortBy.map(value => value),
        sortOrder.map(value => value),
        targetResourceId
      )
    def accountId: AccountId
    def filterCriteria: Optional[
      zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria.ReadOnly
    ]
    def maxResults: Optional[GetCisScanResultDetailsMaxResults]
    def nextToken: Optional[NextToken]
    def scanArn: CisScanArn
    def sortBy: Optional[zio.aws.inspector2.model.CisScanResultDetailsSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder]
    def targetResourceId: ResourceId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getFilterCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaxResults: ZIO[Any, AwsError, GetCisScanResultDetailsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScanArn: ZIO[Any, Nothing, CisScanArn] = ZIO.succeed(scanArn)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.CisScanResultDetailsSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getTargetResourceId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(targetResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest
  ) extends zio.aws.inspector2.model.GetCisScanResultDetailsRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val filterCriteria: Optional[
      zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filterCriteria())
      .map(value =>
        zio.aws.inspector2.model.CisScanResultDetailsFilterCriteria.wrap(value)
      )
    override val maxResults: Optional[GetCisScanResultDetailsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives
            .GetCisScanResultDetailsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val scanArn: CisScanArn =
      zio.aws.inspector2.model.primitives.CisScanArn(impl.scanArn())
    override val sortBy
        : Optional[zio.aws.inspector2.model.CisScanResultDetailsSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.inspector2.model.CisScanResultDetailsSortBy.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.CisSortOrder.wrap(value))
    override val targetResourceId: ResourceId =
      zio.aws.inspector2.model.primitives.ResourceId(impl.targetResourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest
  ): zio.aws.inspector2.model.GetCisScanResultDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
