package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class GetCisScanResultDetailsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    scanResultDetails: Optional[
      Iterable[zio.aws.inspector2.model.CisScanResultDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse = {
    import GetCisScanResultDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        scanResultDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanResultDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.GetCisScanResultDetailsResponse.ReadOnly =
    zio.aws.inspector2.model.GetCisScanResultDetailsResponse
      .wrap(buildAwsValue())
}
object GetCisScanResultDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetCisScanResultDetailsResponse =
      zio.aws.inspector2.model.GetCisScanResultDetailsResponse(
        nextToken.map(value => value),
        scanResultDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def scanResultDetails
        : Optional[List[zio.aws.inspector2.model.CisScanResultDetails.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScanResultDetails: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisScanResultDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("scanResultDetails", scanResultDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse
  ) extends zio.aws.inspector2.model.GetCisScanResultDetailsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val scanResultDetails: Optional[
      List[zio.aws.inspector2.model.CisScanResultDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanResultDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisScanResultDetails.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse
  ): zio.aws.inspector2.model.GetCisScanResultDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
