package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.ReportId
import scala.jdk.CollectionConverters.*
final case class GetSbomExportRequest(reportId: ReportId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest = {
    import GetSbomExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest
      .builder()
      .reportId(ReportId.unwrap(reportId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.GetSbomExportRequest.ReadOnly =
    zio.aws.inspector2.model.GetSbomExportRequest.wrap(buildAwsValue())
}
object GetSbomExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetSbomExportRequest =
      zio.aws.inspector2.model.GetSbomExportRequest(reportId)
    def reportId: ReportId
    def getReportId: ZIO[Any, Nothing, ReportId] = ZIO.succeed(reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest
  ) extends zio.aws.inspector2.model.GetSbomExportRequest.ReadOnly {
    override val reportId: ReportId =
      zio.aws.inspector2.model.primitives.ReportId(impl.reportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest
  ): zio.aws.inspector2.model.GetSbomExportRequest.ReadOnly = new Wrapper(impl)
}
