package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters.*
final case class ImageLayerAggregationResponse(
    accountId: AccountId,
    layerHash: NonEmptyString,
    repository: NonEmptyString,
    resourceId: NonEmptyString,
    severityCounts: Optional[zio.aws.inspector2.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ImageLayerAggregationResponse = {
    import ImageLayerAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ImageLayerAggregationResponse
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .layerHash(NonEmptyString.unwrap(layerHash): java.lang.String)
      .repository(NonEmptyString.unwrap(repository): java.lang.String)
      .resourceId(NonEmptyString.unwrap(resourceId): java.lang.String)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ImageLayerAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.ImageLayerAggregationResponse.wrap(buildAwsValue())
}
object ImageLayerAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ImageLayerAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ImageLayerAggregationResponse =
      zio.aws.inspector2.model.ImageLayerAggregationResponse(
        accountId,
        layerHash,
        repository,
        resourceId,
        severityCounts.map(value => value.asEditable)
      )
    def accountId: AccountId
    def layerHash: NonEmptyString
    def repository: NonEmptyString
    def resourceId: NonEmptyString
    def severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getLayerHash: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(layerHash)
    def getRepository: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(repository)
    def getResourceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceId)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ImageLayerAggregationResponse
  ) extends zio.aws.inspector2.model.ImageLayerAggregationResponse.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val layerHash: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.layerHash())
    override val repository: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.repository())
    override val resourceId: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.resourceId())
    override val severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ImageLayerAggregationResponse
  ): zio.aws.inspector2.model.ImageLayerAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
