package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  MapKey,
  AccountId,
  MapValue,
  DateTimeTimestamp,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionAggregationResponse(
    accountId: Optional[AccountId] = Optional.Absent,
    functionName: Optional[String] = Optional.Absent,
    lambdaTags: Optional[Map[MapKey, MapValue]] = Optional.Absent,
    lastModifiedAt: Optional[DateTimeTimestamp] = Optional.Absent,
    resourceId: NonEmptyString,
    runtime: Optional[String] = Optional.Absent,
    severityCounts: Optional[zio.aws.inspector2.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregationResponse = {
    import LambdaFunctionAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(functionName.map(value => value: java.lang.String))(
        _.functionName
      )
      .optionallyWith(
        lambdaTags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.lambdaTags)
      .optionallyWith(
        lastModifiedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.lastModifiedAt)
      .resourceId(NonEmptyString.unwrap(resourceId): java.lang.String)
      .optionallyWith(runtime.map(value => value: java.lang.String))(_.runtime)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.LambdaFunctionAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.LambdaFunctionAggregationResponse
      .wrap(buildAwsValue())
}
object LambdaFunctionAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.LambdaFunctionAggregationResponse =
      zio.aws.inspector2.model.LambdaFunctionAggregationResponse(
        accountId.map(value => value),
        functionName.map(value => value),
        lambdaTags.map(value => value),
        lastModifiedAt.map(value => value),
        resourceId,
        runtime.map(value => value),
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Optional[AccountId]
    def functionName: Optional[String]
    def lambdaTags: Optional[Map[MapKey, MapValue]]
    def lastModifiedAt: Optional[DateTimeTimestamp]
    def resourceId: NonEmptyString
    def runtime: Optional[String]
    def severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getFunctionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getLambdaTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("lambdaTags", lambdaTags)
    def getLastModifiedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("lastModifiedAt", lastModifiedAt)
    def getResourceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceId)
    def getRuntime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregationResponse
  ) extends zio.aws.inspector2.model.LambdaFunctionAggregationResponse.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val functionName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.functionName())
      .map(value => value: String)
    override val lambdaTags: Optional[Map[MapKey, MapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.inspector2.model.primitives.MapKey(
                key
              ) -> zio.aws.inspector2.model.primitives.MapValue(value)
            })
            .toMap
        )
    override val lastModifiedAt: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedAt())
        .map(value =>
          zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
        )
    override val resourceId: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.resourceId())
    override val runtime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.runtime())
      .map(value => value: String)
    override val severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaFunctionAggregationResponse
  ): zio.aws.inspector2.model.LambdaFunctionAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
