package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LambdaLayerAggregation(
    functionNames: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    layerArns: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    resourceIds: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.LambdaLayerSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregation = {
    import LambdaLayerAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregation
      .builder()
      .optionallyWith(
        functionNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.functionNames)
      .optionallyWith(
        layerArns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.layerArns)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIds)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.LambdaLayerAggregation.ReadOnly =
    zio.aws.inspector2.model.LambdaLayerAggregation.wrap(buildAwsValue())
}
object LambdaLayerAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.LambdaLayerAggregation =
      zio.aws.inspector2.model.LambdaLayerAggregation(
        functionNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        layerArns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def functionNames
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def layerArns
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def resourceIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def sortBy: Optional[zio.aws.inspector2.model.LambdaLayerSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.SortOrder]
    def getFunctionNames: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("functionNames", functionNames)
    def getLayerArns: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("layerArns", layerArns)
    def getResourceIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceIds", resourceIds)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.inspector2.model.LambdaLayerSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregation
  ) extends zio.aws.inspector2.model.LambdaLayerAggregation.ReadOnly {
    override val functionNames
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val layerArns
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layerArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val sortBy: Optional[zio.aws.inspector2.model.LambdaLayerSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.inspector2.model.LambdaLayerSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.inspector2.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregation
  ): zio.aws.inspector2.model.LambdaLayerAggregation.ReadOnly = new Wrapper(
    impl
  )
}
