package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCisScanConfigurationsFilterCriteria(
    scanConfigurationArnFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    scanNameFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    targetResourceTagFilters: Optional[
      Iterable[zio.aws.inspector2.model.TagFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsFilterCriteria = {
    import ListCisScanConfigurationsFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsFilterCriteria
      .builder()
      .optionallyWith(
        scanConfigurationArnFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanConfigurationArnFilters)
      .optionallyWith(
        scanNameFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanNameFilters)
      .optionallyWith(
        targetResourceTagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetResourceTagFilters)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria.ReadOnly =
    zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria
      .wrap(buildAwsValue())
}
object ListCisScanConfigurationsFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria =
      zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria(
        scanConfigurationArnFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanNameFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetResourceTagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scanConfigurationArnFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def scanNameFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def targetResourceTagFilters
        : Optional[List[zio.aws.inspector2.model.TagFilter.ReadOnly]]
    def getScanConfigurationArnFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "scanConfigurationArnFilters",
      scanConfigurationArnFilters
    )
    def getScanNameFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanNameFilters", scanNameFilters)
    def getTargetResourceTagFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetResourceTagFilters",
      targetResourceTagFilters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsFilterCriteria
  ) extends zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria.ReadOnly {
    override val scanConfigurationArnFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanConfigurationArnFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val scanNameFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanNameFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val targetResourceTagFilters
        : Optional[List[zio.aws.inspector2.model.TagFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetResourceTagFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.TagFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsFilterCriteria
  ): zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria.ReadOnly =
    new Wrapper(impl)
}
