package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  NextToken,
  ListCisScanConfigurationsMaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCisScanConfigurationsRequest(
    filterCriteria: Optional[
      zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria
    ] = Optional.Absent,
    maxResults: Optional[ListCisScanConfigurationsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.CisScanConfigurationsSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest = {
    import ListCisScanConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest
      .builder()
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maxResults.map(value =>
          ListCisScanConfigurationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListCisScanConfigurationsRequest.ReadOnly =
    zio.aws.inspector2.model.ListCisScanConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListCisScanConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListCisScanConfigurationsRequest =
      zio.aws.inspector2.model.ListCisScanConfigurationsRequest(
        filterCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def filterCriteria: Optional[
      zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria.ReadOnly
    ]
    def maxResults: Optional[ListCisScanConfigurationsMaxResults]
    def nextToken: Optional[NextToken]
    def sortBy: Optional[zio.aws.inspector2.model.CisScanConfigurationsSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder]
    def getFilterCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaxResults: ZIO[Any, AwsError, ListCisScanConfigurationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.CisScanConfigurationsSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest
  ) extends zio.aws.inspector2.model.ListCisScanConfigurationsRequest.ReadOnly {
    override val filterCriteria: Optional[
      zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filterCriteria())
      .map(value =>
        zio.aws.inspector2.model.ListCisScanConfigurationsFilterCriteria
          .wrap(value)
      )
    override val maxResults: Optional[ListCisScanConfigurationsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives
            .ListCisScanConfigurationsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val sortBy
        : Optional[zio.aws.inspector2.model.CisScanConfigurationsSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.inspector2.model.CisScanConfigurationsSortBy.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.CisSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest
  ): zio.aws.inspector2.model.ListCisScanConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
