package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListCisScanConfigurationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    scanConfigurations: Optional[
      Iterable[zio.aws.inspector2.model.CisScanConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse = {
    import ListCisScanConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        scanConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListCisScanConfigurationsResponse.ReadOnly =
    zio.aws.inspector2.model.ListCisScanConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListCisScanConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListCisScanConfigurationsResponse =
      zio.aws.inspector2.model.ListCisScanConfigurationsResponse(
        nextToken.map(value => value),
        scanConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def scanConfigurations
        : Optional[List[zio.aws.inspector2.model.CisScanConfiguration.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScanConfigurations: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisScanConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("scanConfigurations", scanConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse
  ) extends zio.aws.inspector2.model.ListCisScanConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val scanConfigurations: Optional[
      List[zio.aws.inspector2.model.CisScanConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisScanConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse
  ): zio.aws.inspector2.model.ListCisScanConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
