package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  CisScanArn,
  NextToken,
  CisScanResultsMaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCisScanResultsAggregatedByChecksRequest(
    filterCriteria: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria
    ] = Optional.Absent,
    maxResults: Optional[CisScanResultsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    scanArn: CisScanArn,
    sortBy: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByChecksSortBy
    ] = Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest = {
    import ListCisScanResultsAggregatedByChecksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest
      .builder()
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maxResults.map(value => CisScanResultsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .scanArn(CisScanArn.unwrap(scanArn): java.lang.String)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksRequest.ReadOnly =
    zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksRequest
      .wrap(buildAwsValue())
}
object ListCisScanResultsAggregatedByChecksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksRequest =
      zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksRequest(
        filterCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        scanArn,
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def filterCriteria: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria.ReadOnly
    ]
    def maxResults: Optional[CisScanResultsMaxResults]
    def nextToken: Optional[NextToken]
    def scanArn: CisScanArn
    def sortBy: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByChecksSortBy
    ]
    def sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder]
    def getFilterCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaxResults: ZIO[Any, AwsError, CisScanResultsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScanArn: ZIO[Any, Nothing, CisScanArn] = ZIO.succeed(scanArn)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.CisScanResultsAggregatedByChecksSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest
  ) extends zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksRequest.ReadOnly {
    override val filterCriteria: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filterCriteria())
      .map(value =>
        zio.aws.inspector2.model.CisScanResultsAggregatedByChecksFilterCriteria
          .wrap(value)
      )
    override val maxResults: Optional[CisScanResultsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives.CisScanResultsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val scanArn: CisScanArn =
      zio.aws.inspector2.model.primitives.CisScanArn(impl.scanArn())
    override val sortBy: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByChecksSortBy
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value =>
        zio.aws.inspector2.model.CisScanResultsAggregatedByChecksSortBy
          .wrap(value)
      )
    override val sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.CisSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest
  ): zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksRequest.ReadOnly =
    new Wrapper(impl)
}
