package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListCisScanResultsAggregatedByChecksResponse(
    checkAggregations: Optional[
      Iterable[zio.aws.inspector2.model.CisCheckAggregation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse = {
    import ListCisScanResultsAggregatedByChecksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse
      .builder()
      .optionallyWith(
        checkAggregations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.checkAggregations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksResponse.ReadOnly =
    zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksResponse
      .wrap(buildAwsValue())
}
object ListCisScanResultsAggregatedByChecksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksResponse =
      zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksResponse(
        checkAggregations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def checkAggregations
        : Optional[List[zio.aws.inspector2.model.CisCheckAggregation.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getCheckAggregations: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisCheckAggregation.ReadOnly
    ]] = AwsError.unwrapOptionField("checkAggregations", checkAggregations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse
  ) extends zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksResponse.ReadOnly {
    override val checkAggregations: Optional[
      List[zio.aws.inspector2.model.CisCheckAggregation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.checkAggregations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisCheckAggregation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse
  ): zio.aws.inspector2.model.ListCisScanResultsAggregatedByChecksResponse.ReadOnly =
    new Wrapper(impl)
}
