package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  CisScanArn,
  NextToken,
  CisScanResultsMaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCisScanResultsAggregatedByTargetResourceRequest(
    filterCriteria: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria
    ] = Optional.Absent,
    maxResults: Optional[CisScanResultsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    scanArn: CisScanArn,
    sortBy: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceSortBy
    ] = Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest = {
    import ListCisScanResultsAggregatedByTargetResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest
      .builder()
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maxResults.map(value => CisScanResultsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .scanArn(CisScanArn.unwrap(scanArn): java.lang.String)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest.ReadOnly =
    zio.aws.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest
      .wrap(buildAwsValue())
}
object ListCisScanResultsAggregatedByTargetResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest =
      zio.aws.inspector2.model
        .ListCisScanResultsAggregatedByTargetResourceRequest(
          filterCriteria.map(value => value.asEditable),
          maxResults.map(value => value),
          nextToken.map(value => value),
          scanArn,
          sortBy.map(value => value),
          sortOrder.map(value => value)
        )
    def filterCriteria: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria.ReadOnly
    ]
    def maxResults: Optional[CisScanResultsMaxResults]
    def nextToken: Optional[NextToken]
    def scanArn: CisScanArn
    def sortBy: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceSortBy
    ]
    def sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder]
    def getFilterCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaxResults: ZIO[Any, AwsError, CisScanResultsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScanArn: ZIO[Any, Nothing, CisScanArn] = ZIO.succeed(scanArn)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest
  ) extends zio.aws.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest.ReadOnly {
    override val filterCriteria: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filterCriteria())
      .map(value =>
        zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceFilterCriteria
          .wrap(value)
      )
    override val maxResults: Optional[CisScanResultsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives.CisScanResultsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val scanArn: CisScanArn =
      zio.aws.inspector2.model.primitives.CisScanArn(impl.scanArn())
    override val sortBy: Optional[
      zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceSortBy
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value =>
        zio.aws.inspector2.model.CisScanResultsAggregatedByTargetResourceSortBy
          .wrap(value)
      )
    override val sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.CisSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest
  ): zio.aws.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest.ReadOnly =
    new Wrapper(impl)
}
