package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListCisScanResultsAggregatedByTargetResourceResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    targetResourceAggregations: Optional[
      Iterable[zio.aws.inspector2.model.CisTargetResourceAggregation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse = {
    import ListCisScanResultsAggregatedByTargetResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        targetResourceAggregations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetResourceAggregations)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse.ReadOnly =
    zio.aws.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse
      .wrap(buildAwsValue())
}
object ListCisScanResultsAggregatedByTargetResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse =
      zio.aws.inspector2.model
        .ListCisScanResultsAggregatedByTargetResourceResponse(
          nextToken.map(value => value),
          targetResourceAggregations.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def nextToken: Optional[NextToken]
    def targetResourceAggregations: Optional[
      List[zio.aws.inspector2.model.CisTargetResourceAggregation.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTargetResourceAggregations: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisTargetResourceAggregation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetResourceAggregations",
      targetResourceAggregations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse
  ) extends zio.aws.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val targetResourceAggregations: Optional[
      List[zio.aws.inspector2.model.CisTargetResourceAggregation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetResourceAggregations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisTargetResourceAggregation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse
  ): zio.aws.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse.ReadOnly =
    new Wrapper(impl)
}
