package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ListCisScansDetailLevel {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel
}
object ListCisScansDetailLevel {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel
  ): zio.aws.inspector2.model.ListCisScansDetailLevel = value match {
    case software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel.ORGANIZATION =>
      val r = ORGANIZATION
      r
    case software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel.MEMBER =>
      val r = MEMBER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ListCisScansDetailLevel {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel =
      software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object ORGANIZATION
      extends zio.aws.inspector2.model.ListCisScansDetailLevel {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel =
      software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel.ORGANIZATION
  }
  case object MEMBER extends zio.aws.inspector2.model.ListCisScansDetailLevel {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel =
      software.amazon.awssdk.services.inspector2.model.ListCisScansDetailLevel.MEMBER
  }
}
