package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCisScansFilterCriteria(
    failedChecksFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisNumberFilter]
    ] = Optional.Absent,
    scanArnFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    scanAtFilters: Optional[Iterable[zio.aws.inspector2.model.CisDateFilter]] =
      Optional.Absent,
    scanConfigurationArnFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    scanNameFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    scanStatusFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisScanStatusFilter]
    ] = Optional.Absent,
    scheduledByFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    targetAccountIdFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    targetResourceIdFilters: Optional[
      Iterable[zio.aws.inspector2.model.CisStringFilter]
    ] = Optional.Absent,
    targetResourceTagFilters: Optional[
      Iterable[zio.aws.inspector2.model.TagFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCisScansFilterCriteria = {
    import ListCisScansFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCisScansFilterCriteria
      .builder()
      .optionallyWith(
        failedChecksFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedChecksFilters)
      .optionallyWith(
        scanArnFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanArnFilters)
      .optionallyWith(
        scanAtFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanAtFilters)
      .optionallyWith(
        scanConfigurationArnFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanConfigurationArnFilters)
      .optionallyWith(
        scanNameFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanNameFilters)
      .optionallyWith(
        scanStatusFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanStatusFilters)
      .optionallyWith(
        scheduledByFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledByFilters)
      .optionallyWith(
        targetAccountIdFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetAccountIdFilters)
      .optionallyWith(
        targetResourceIdFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetResourceIdFilters)
      .optionallyWith(
        targetResourceTagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetResourceTagFilters)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListCisScansFilterCriteria.ReadOnly =
    zio.aws.inspector2.model.ListCisScansFilterCriteria.wrap(buildAwsValue())
}
object ListCisScansFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCisScansFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListCisScansFilterCriteria =
      zio.aws.inspector2.model.ListCisScansFilterCriteria(
        failedChecksFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanArnFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanAtFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanConfigurationArnFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanNameFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanStatusFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scheduledByFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetAccountIdFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetResourceIdFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetResourceTagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedChecksFilters
        : Optional[List[zio.aws.inspector2.model.CisNumberFilter.ReadOnly]]
    def scanArnFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def scanAtFilters
        : Optional[List[zio.aws.inspector2.model.CisDateFilter.ReadOnly]]
    def scanConfigurationArnFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def scanNameFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def scanStatusFilters
        : Optional[List[zio.aws.inspector2.model.CisScanStatusFilter.ReadOnly]]
    def scheduledByFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def targetAccountIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def targetResourceIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]]
    def targetResourceTagFilters
        : Optional[List[zio.aws.inspector2.model.TagFilter.ReadOnly]]
    def getFailedChecksFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisNumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("failedChecksFilters", failedChecksFilters)
    def getScanArnFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanArnFilters", scanArnFilters)
    def getScanAtFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisDateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanAtFilters", scanAtFilters)
    def getScanConfigurationArnFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "scanConfigurationArnFilters",
      scanConfigurationArnFilters
    )
    def getScanNameFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanNameFilters", scanNameFilters)
    def getScanStatusFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisScanStatusFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanStatusFilters", scanStatusFilters)
    def getScheduledByFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scheduledByFilters", scheduledByFilters)
    def getTargetAccountIdFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetAccountIdFilters",
      targetAccountIdFilters
    )
    def getTargetResourceIdFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CisStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetResourceIdFilters",
      targetResourceIdFilters
    )
    def getTargetResourceTagFilters: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetResourceTagFilters",
      targetResourceTagFilters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScansFilterCriteria
  ) extends zio.aws.inspector2.model.ListCisScansFilterCriteria.ReadOnly {
    override val failedChecksFilters
        : Optional[List[zio.aws.inspector2.model.CisNumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedChecksFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisNumberFilter.wrap(item)
          }.toList
        )
    override val scanArnFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanArnFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val scanAtFilters
        : Optional[List[zio.aws.inspector2.model.CisDateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanAtFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisDateFilter.wrap(item)
          }.toList
        )
    override val scanConfigurationArnFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanConfigurationArnFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val scanNameFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanNameFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val scanStatusFilters: Optional[
      List[zio.aws.inspector2.model.CisScanStatusFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanStatusFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CisScanStatusFilter.wrap(item)
        }.toList
      )
    override val scheduledByFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledByFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val targetAccountIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetAccountIdFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val targetResourceIdFilters
        : Optional[List[zio.aws.inspector2.model.CisStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetResourceIdFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisStringFilter.wrap(item)
          }.toList
        )
    override val targetResourceTagFilters
        : Optional[List[zio.aws.inspector2.model.TagFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetResourceTagFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.TagFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScansFilterCriteria
  ): zio.aws.inspector2.model.ListCisScansFilterCriteria.ReadOnly = new Wrapper(
    impl
  )
}
