package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{NextToken, ListCisScansMaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCisScansRequest(
    detailLevel: Optional[zio.aws.inspector2.model.ListCisScansDetailLevel] =
      Optional.Absent,
    filterCriteria: Optional[
      zio.aws.inspector2.model.ListCisScansFilterCriteria
    ] = Optional.Absent,
    maxResults: Optional[ListCisScansMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.ListCisScansSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCisScansRequest = {
    import ListCisScansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCisScansRequest
      .builder()
      .optionallyWith(detailLevel.map(value => value.unwrap))(_.detailLevel)
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maxResults.map(value => ListCisScansMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListCisScansRequest.ReadOnly =
    zio.aws.inspector2.model.ListCisScansRequest.wrap(buildAwsValue())
}
object ListCisScansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCisScansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListCisScansRequest =
      zio.aws.inspector2.model.ListCisScansRequest(
        detailLevel.map(value => value),
        filterCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def detailLevel: Optional[zio.aws.inspector2.model.ListCisScansDetailLevel]
    def filterCriteria
        : Optional[zio.aws.inspector2.model.ListCisScansFilterCriteria.ReadOnly]
    def maxResults: Optional[ListCisScansMaxResults]
    def nextToken: Optional[NextToken]
    def sortBy: Optional[zio.aws.inspector2.model.ListCisScansSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder]
    def getDetailLevel
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ListCisScansDetailLevel] =
      AwsError.unwrapOptionField("detailLevel", detailLevel)
    def getFilterCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ListCisScansFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaxResults: ZIO[Any, AwsError, ListCisScansMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ListCisScansSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.inspector2.model.CisSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScansRequest
  ) extends zio.aws.inspector2.model.ListCisScansRequest.ReadOnly {
    override val detailLevel
        : Optional[zio.aws.inspector2.model.ListCisScansDetailLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detailLevel())
        .map(value =>
          zio.aws.inspector2.model.ListCisScansDetailLevel.wrap(value)
        )
    override val filterCriteria: Optional[
      zio.aws.inspector2.model.ListCisScansFilterCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filterCriteria())
      .map(value =>
        zio.aws.inspector2.model.ListCisScansFilterCriteria.wrap(value)
      )
    override val maxResults: Optional[ListCisScansMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives.ListCisScansMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val sortBy: Optional[zio.aws.inspector2.model.ListCisScansSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.inspector2.model.ListCisScansSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.inspector2.model.CisSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.CisSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScansRequest
  ): zio.aws.inspector2.model.ListCisScansRequest.ReadOnly = new Wrapper(impl)
}
