package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListCisScansResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    scans: Optional[Iterable[zio.aws.inspector2.model.CisScan]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCisScansResponse = {
    import ListCisScansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCisScansResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        scans.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scans)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListCisScansResponse.ReadOnly =
    zio.aws.inspector2.model.ListCisScansResponse.wrap(buildAwsValue())
}
object ListCisScansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCisScansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListCisScansResponse =
      zio.aws.inspector2.model.ListCisScansResponse(
        nextToken.map(value => value),
        scans.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def scans: Optional[List[zio.aws.inspector2.model.CisScan.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScans
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.CisScan.ReadOnly]] =
      AwsError.unwrapOptionField("scans", scans)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScansResponse
  ) extends zio.aws.inspector2.model.ListCisScansResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val scans
        : Optional[List[zio.aws.inspector2.model.CisScan.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scans())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CisScan.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCisScansResponse
  ): zio.aws.inspector2.model.ListCisScansResponse.ReadOnly = new Wrapper(impl)
}
