package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListDelegatedAdminAccountsResponse(
    delegatedAdminAccounts: Optional[
      Iterable[zio.aws.inspector2.model.DelegatedAdminAccount]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse = {
    import ListDelegatedAdminAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse
      .builder()
      .optionallyWith(
        delegatedAdminAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.delegatedAdminAccounts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse.ReadOnly =
    zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse
      .wrap(buildAwsValue())
}
object ListDelegatedAdminAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse =
      zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse(
        delegatedAdminAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def delegatedAdminAccounts: Optional[
      List[zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getDelegatedAdminAccounts: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "delegatedAdminAccounts",
      delegatedAdminAccounts
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse
  ) extends zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse.ReadOnly {
    override val delegatedAdminAccounts: Optional[
      List[zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.delegatedAdminAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.DelegatedAdminAccount.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse
  ): zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
