package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{NextToken, ListMembersMaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMembersRequest(
    maxResults: Optional[ListMembersMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    onlyAssociated: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListMembersRequest = {
    import ListMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListMembersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ListMembersMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(onlyAssociated.map(value => value: java.lang.Boolean))(
        _.onlyAssociated
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListMembersRequest.ReadOnly =
    zio.aws.inspector2.model.ListMembersRequest.wrap(buildAwsValue())
}
object ListMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListMembersRequest =
      zio.aws.inspector2.model.ListMembersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        onlyAssociated.map(value => value)
      )
    def maxResults: Optional[ListMembersMaxResults]
    def nextToken: Optional[NextToken]
    def onlyAssociated: Optional[Boolean]
    def getMaxResults: ZIO[Any, AwsError, ListMembersMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOnlyAssociated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("onlyAssociated", onlyAssociated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListMembersRequest
  ) extends zio.aws.inspector2.model.ListMembersRequest.ReadOnly {
    override val maxResults: Optional[ListMembersMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives.ListMembersMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val onlyAssociated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.onlyAssociated())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListMembersRequest
  ): zio.aws.inspector2.model.ListMembersRequest.ReadOnly = new Wrapper(impl)
}
