package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  ListUsageTotalsNextToken,
  ListUsageTotalsMaxResults,
  UsageAccountId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListUsageTotalsRequest(
    accountIds: Optional[Iterable[UsageAccountId]] = Optional.Absent,
    maxResults: Optional[ListUsageTotalsMaxResults] = Optional.Absent,
    nextToken: Optional[ListUsageTotalsNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest = {
    import ListUsageTotalsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            UsageAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        maxResults.map(value =>
          ListUsageTotalsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          ListUsageTotalsNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListUsageTotalsRequest.ReadOnly =
    zio.aws.inspector2.model.ListUsageTotalsRequest.wrap(buildAwsValue())
}
object ListUsageTotalsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListUsageTotalsRequest =
      zio.aws.inspector2.model.ListUsageTotalsRequest(
        accountIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def accountIds: Optional[List[UsageAccountId]]
    def maxResults: Optional[ListUsageTotalsMaxResults]
    def nextToken: Optional[ListUsageTotalsNextToken]
    def getAccountIds: ZIO[Any, AwsError, List[UsageAccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getMaxResults: ZIO[Any, AwsError, ListUsageTotalsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, ListUsageTotalsNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest
  ) extends zio.aws.inspector2.model.ListUsageTotalsRequest.ReadOnly {
    override val accountIds: Optional[List[UsageAccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.UsageAccountId(item)
          }.toList
        )
    override val maxResults: Optional[ListUsageTotalsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives.ListUsageTotalsMaxResults(value)
        )
    override val nextToken: Optional[ListUsageTotalsNextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.inspector2.model.primitives.ListUsageTotalsNextToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest
  ): zio.aws.inspector2.model.ListUsageTotalsRequest.ReadOnly = new Wrapper(
    impl
  )
}
