package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters.*
final case class MemberAccountEc2DeepInspectionStatusState(
    accountId: AccountId,
    errorMessage: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[zio.aws.inspector2.model.Ec2DeepInspectionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState = {
    import MemberAccountEc2DeepInspectionStatusState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        errorMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState.ReadOnly =
    zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState
      .wrap(buildAwsValue())
}
object MemberAccountEc2DeepInspectionStatusState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState =
      zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState(
        accountId,
        errorMessage.map(value => value),
        status.map(value => value)
      )
    def accountId: AccountId
    def errorMessage: Optional[NonEmptyString]
    def status: Optional[zio.aws.inspector2.model.Ec2DeepInspectionStatus]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getErrorMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Ec2DeepInspectionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState
  ) extends zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val errorMessage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val status
        : Optional[zio.aws.inspector2.model.Ec2DeepInspectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.inspector2.model.Ec2DeepInspectionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState
  ): zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState.ReadOnly =
    new Wrapper(impl)
}
