package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MonthlySchedule(
    day: zio.aws.inspector2.model.Day,
    startTime: zio.aws.inspector2.model.Time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.MonthlySchedule = {
    import MonthlySchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.MonthlySchedule
      .builder()
      .day(day.unwrap)
      .startTime(startTime.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.MonthlySchedule.ReadOnly =
    zio.aws.inspector2.model.MonthlySchedule.wrap(buildAwsValue())
}
object MonthlySchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.MonthlySchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.MonthlySchedule =
      zio.aws.inspector2.model.MonthlySchedule(day, startTime.asEditable)
    def day: zio.aws.inspector2.model.Day
    def startTime: zio.aws.inspector2.model.Time.ReadOnly
    def getDay: ZIO[Any, Nothing, zio.aws.inspector2.model.Day] =
      ZIO.succeed(day)
    def getStartTime
        : ZIO[Any, Nothing, zio.aws.inspector2.model.Time.ReadOnly] =
      ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.MonthlySchedule
  ) extends zio.aws.inspector2.model.MonthlySchedule.ReadOnly {
    override val day: zio.aws.inspector2.model.Day =
      zio.aws.inspector2.model.Day.wrap(impl.day())
    override val startTime: zio.aws.inspector2.model.Time.ReadOnly =
      zio.aws.inspector2.model.Time.wrap(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.MonthlySchedule
  ): zio.aws.inspector2.model.MonthlySchedule.ReadOnly = new Wrapper(impl)
}
