package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait PackageManager {
  def unwrap: software.amazon.awssdk.services.inspector2.model.PackageManager
}
object PackageManager {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.PackageManager
  ): zio.aws.inspector2.model.PackageManager = value match {
    case software.amazon.awssdk.services.inspector2.model.PackageManager.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.BUNDLER =>
      val r = BUNDLER
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.CARGO =>
      val r = CARGO
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.COMPOSER =>
      val r = COMPOSER
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.NPM =>
      val r = NPM
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.NUGET =>
      val r = NUGET
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.PIPENV =>
      val r = PIPENV
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.POETRY =>
      val r = POETRY
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.YARN =>
      val r = YARN
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.GOBINARY =>
      val r = GOBINARY
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.GOMOD =>
      val r = GOMOD
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.JAR =>
      val r = JAR
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.OS =>
      val r = OS
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.PIP =>
      val r = PIP
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.PYTHONPKG =>
      val r = PYTHONPKG
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.NODEPKG =>
      val r = NODEPKG
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.POM =>
      val r = POM
      r
    case software.amazon.awssdk.services.inspector2.model.PackageManager.GEMSPEC =>
      val r = GEMSPEC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.UNKNOWN_TO_SDK_VERSION
  }
  case object BUNDLER extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.BUNDLER
  }
  case object CARGO extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.CARGO
  }
  case object COMPOSER extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.COMPOSER
  }
  case object NPM extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.NPM
  }
  case object NUGET extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.NUGET
  }
  case object PIPENV extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.PIPENV
  }
  case object POETRY extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.POETRY
  }
  case object YARN extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.YARN
  }
  case object GOBINARY extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.GOBINARY
  }
  case object GOMOD extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.GOMOD
  }
  case object JAR extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.JAR
  }
  case object OS extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.OS
  }
  case object PIP extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.PIP
  }
  case object PYTHONPKG extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.PYTHONPKG
  }
  case object NODEPKG extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.NODEPKG
  }
  case object POM extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.POM
  }
  case object GEMSPEC extends zio.aws.inspector2.model.PackageManager {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageManager =
      software.amazon.awssdk.services.inspector2.model.PackageManager.GEMSPEC
  }
}
