package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait PackageType {
  def unwrap: software.amazon.awssdk.services.inspector2.model.PackageType
}
object PackageType {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.PackageType
  ): zio.aws.inspector2.model.PackageType = value match {
    case software.amazon.awssdk.services.inspector2.model.PackageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.PackageType.IMAGE =>
      val r = IMAGE
      r
    case software.amazon.awssdk.services.inspector2.model.PackageType.ZIP =>
      val r = ZIP
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.PackageType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageType =
      software.amazon.awssdk.services.inspector2.model.PackageType.UNKNOWN_TO_SDK_VERSION
  }
  case object IMAGE extends zio.aws.inspector2.model.PackageType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageType =
      software.amazon.awssdk.services.inspector2.model.PackageType.IMAGE
  }
  case object ZIP extends zio.aws.inspector2.model.PackageType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageType =
      software.amazon.awssdk.services.inspector2.model.PackageType.ZIP
  }
}
