package zio.aws.inspector2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.Port
import scala.jdk.CollectionConverters.*
final case class PortRange(begin: Port, end: Port) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.PortRange = {
    import PortRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.PortRange
      .builder()
      .begin(Port.unwrap(begin): Integer)
      .end(Port.unwrap(end): Integer)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.PortRange.ReadOnly =
    zio.aws.inspector2.model.PortRange.wrap(buildAwsValue())
}
object PortRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.PortRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.PortRange =
      zio.aws.inspector2.model.PortRange(begin, end)
    def begin: Port
    def end: Port
    def getBegin: ZIO[Any, Nothing, Port] = ZIO.succeed(begin)
    def getEnd: ZIO[Any, Nothing, Port] = ZIO.succeed(end)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.PortRange
  ) extends zio.aws.inspector2.model.PortRange.ReadOnly {
    override val begin: Port =
      zio.aws.inspector2.model.primitives.Port(impl.begin())
    override val end: Port =
      zio.aws.inspector2.model.primitives.Port(impl.end())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.PortRange
  ): zio.aws.inspector2.model.PortRange.ReadOnly = new Wrapper(impl)
}
